/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.views;

import com.aptana.core.CoreStrings;
import com.aptana.core.util.FileUtil;
import com.aptana.ide.core.io.IBaseRemoteConnectionPoint;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.syncing.ui.SyncingUIPlugin;
import com.aptana.ide.syncing.ui.views.ConnectionPointLabelProvider;
import com.aptana.ide.syncing.ui.views.Messages;
import com.aptana.ide.ui.io.IOUIPlugin;
import com.aptana.ide.ui.io.Utils;
import com.aptana.ide.ui.io.actions.CopyFilesOperation;
import com.aptana.ide.ui.io.navigator.FileTreeContentProvider;
import com.aptana.ide.ui.io.navigator.FileTreeNameSorter;
import com.aptana.ide.ui.io.navigator.actions.FileSystemDeleteAction;
import com.aptana.ide.ui.io.navigator.actions.FileSystemRenameAction;
import com.aptana.ide.ui.io.navigator.actions.OpenFileAction;
import com.aptana.ui.util.SWTUtils;
import com.aptana.ui.util.UIUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class ConnectionPointComposite
implements SelectionListener,
ISelectionChangedListener,
IDoubleClickListener,
TransferDragSourceListener,
DropTargetListener {
    private static final String[] COLUMN_NAMES = new String[]{Messages.ConnectionPointComposite_Column_Filename, Messages.ConnectionPointComposite_Column_Size, Messages.ConnectionPointComposite_Column_LastModified};
    private Composite fMain;
    private Link fEndPointLink;
    private ToolItem fRefreshItem;
    private ToolItem fHomeItem;
    private Link fPathLink;
    private TreeViewer fTreeViewer;
    private MenuItem fOpenItem;
    private MenuItem fTransferItem;
    private MenuItem fDeleteItem;
    private MenuItem fRenameItem;
    private MenuItem fRefreshMenuItem;
    private MenuItem fPropertiesItem;
    private String fName;
    private IConnectionPoint fConnectionPoint;
    private List<IAdaptable> fEndPointData;
    private Client fClient;

    public ConnectionPointComposite(Composite parent, String name, Client client) {
        this.fName = name;
        this.fClient = client;
        this.fEndPointData = new ArrayList<IAdaptable>();
        this.fMain = this.createControl(parent);
    }

    public Control getControl() {
        return this.fMain;
    }

    public IAdaptable getCurrentInput() {
        return (IAdaptable)this.fTreeViewer.getInput();
    }

    public IAdaptable[] getSelectedElements() {
        ISelection selection = this.fTreeViewer.getSelection();
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return new IAdaptable[0];
        }
        Object[] elements = ((IStructuredSelection)selection).toArray();
        ArrayList<IAdaptable> list = new ArrayList<IAdaptable>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IAdaptable) {
                list.add((IAdaptable)element);
            }
            ++n2;
        }
        return list.toArray(new IAdaptable[list.size()]);
    }

    public void setFocus() {
        this.fMain.setFocus();
    }

    public void setConnectionPoint(IConnectionPoint connection) {
        this.fConnectionPoint = connection;
        this.fEndPointData.clear();
        if (this.fConnectionPoint == null) {
            this.fEndPointLink.setText("");
        } else {
            IPath path;
            String label;
            String tooltip = label = connection.getName();
            if (connection instanceof IBaseRemoteConnectionPoint && (path = ((IBaseRemoteConnectionPoint)connection).getPath()).segmentCount() > 0) {
                tooltip = MessageFormat.format("{0} ({1})", connection.getName(), path.toPortableString());
            }
            this.fEndPointLink.setText(MessageFormat.format("<a>{0}</a>", label));
            this.fEndPointLink.setToolTipText(tooltip);
            this.fEndPointData.add((IAdaptable)this.fConnectionPoint);
        }
        this.setPath("");
        this.fMain.layout(true, true);
        this.fTreeViewer.setInput((Object)connection);
    }

    public void addTreeFocusListener(FocusListener listener) {
        this.fTreeViewer.getControl().addFocusListener(listener);
    }

    public void refresh() {
        Object input = this.fTreeViewer.getInput();
        IResource resource = null;
        if (input instanceof IAdaptable) {
            resource = (IResource)((IAdaptable)input).getAdapter(IResource.class);
        }
        if (resource != null) {
            try {
                resource.refreshLocal(2, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        this.updateContent(this.fEndPointData.get(this.fEndPointData.size() - 1));
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.fRefreshItem) {
            this.refresh();
        } else if (source == this.fHomeItem) {
            this.gotoHome();
        } else if (source == this.fOpenItem) {
            this.open(this.fTreeViewer.getSelection());
        } else if (source == this.fTransferItem) {
            if (this.fClient != null) {
                this.fClient.transfer(this);
            }
        } else if (source == this.fDeleteItem) {
            this.delete(this.fTreeViewer.getSelection());
        } else if (source == this.fRenameItem) {
            this.rename();
        } else if (source == this.fRefreshMenuItem) {
            this.refresh(this.fTreeViewer.getSelection());
        } else if (source == this.fPropertiesItem) {
            this.openPropertyPage(this.fTreeViewer.getSelection());
        } else if (source == this.fPathLink) {
            this.updateContent(this.fEndPointData.get(Integer.parseInt(e.text) + 1));
        } else if (source == this.fEndPointLink) {
            this.gotoHome();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateMenuStates();
    }

    public void doubleClick(DoubleClickEvent event) {
        if (this.fClient == null) {
            this.open(event.getSelection());
        } else {
            Object object = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (object instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)object;
                if (Utils.isDirectory((IAdaptable)((IAdaptable)object))) {
                    this.updateContent(adaptable);
                } else {
                    this.fClient.transfer(this);
                }
            }
        }
    }

    public Transfer getTransfer() {
        return LocalSelectionTransfer.getTransfer();
    }

    public void dragFinished(DragSourceEvent event) {
        LocalSelectionTransfer.getTransfer().setSelection(null);
        LocalSelectionTransfer.getTransfer().setSelectionSetTime(0L);
    }

    public void dragSetData(DragSourceEvent event) {
        event.data = this.fTreeViewer.getSelection();
    }

    public void dragStart(DragSourceEvent event) {
        LocalSelectionTransfer.getTransfer().setSelection(this.fTreeViewer.getSelection());
        LocalSelectionTransfer.getTransfer().setSelectionSetTime((long)event.time & 0xFFFFFFFFL);
    }

    public void dragEnter(DropTargetEvent event) {
        if (event.detail == 16) {
            event.detail = (event.operations & 1) == 0 ? 0 : 1;
        }
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        ITreeSelection selection;
        TreePath[] paths;
        IFileStore targetStore = null;
        if (event.item == null) {
            targetStore = Utils.getFileStore((Object)((IAdaptable)this.fTreeViewer.getInput()));
        } else {
            TreeItem target = (TreeItem)event.item;
            targetStore = ConnectionPointComposite.getFolderStore((IAdaptable)target.getData());
        }
        if (targetStore == null) {
            return;
        }
        if (event.data instanceof ITreeSelection && (paths = (selection = (ITreeSelection)event.data).getPaths()).length > 0) {
            ArrayList<IAdaptable> elements = new ArrayList<IAdaptable>();
            TreePath[] treePathArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                boolean alreadyIn = false;
                TreePath[] treePathArray2 = paths;
                int n3 = paths.length;
                int n4 = 0;
                while (n4 < n3) {
                    TreePath path2 = treePathArray2[n4];
                    if (!path.equals((Object)path2) && path.startsWith(path2, null)) {
                        alreadyIn = true;
                        break;
                    }
                    ++n4;
                }
                if (!alreadyIn) {
                    elements.add((IAdaptable)path.getLastSegment());
                }
                ++n2;
            }
            CopyFilesOperation operation = new CopyFilesOperation(this.getControl().getShell());
            operation.copyFiles(elements.toArray(new IAdaptable[elements.size()]), targetStore, (IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    IOUIPlugin.refreshNavigatorView((Object)ConnectionPointComposite.this.fTreeViewer.getInput());
                    UIUtils.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            ConnectionPointComposite.this.refresh();
                        }
                    });
                }
            });
        }
    }

    public void dropAccept(DropTargetEvent event) {
    }

    protected Composite createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        main.setLayout((Layout)layout);
        Composite top = this.createTopComposite(main);
        top.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite path = this.createPathComposite(main);
        path.setLayoutData((Object)new GridData(4, 4, true, false));
        TreeViewer treeViewer = this.createTreeViewer(main);
        treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        return main;
    }

    private Composite createTopComposite(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        main.setLayout((Layout)layout);
        Label label = new Label(main, 0);
        label.setText(String.valueOf(this.fName) + ":");
        this.fEndPointLink = new Link(main, 0);
        this.fEndPointLink.addSelectionListener((SelectionListener)this);
        ToolBar toolbar = new ToolBar(main, 0x800000);
        this.fHomeItem = new ToolItem(toolbar, 8);
        this.fHomeItem.setImage(SyncingUIPlugin.getImage("icons/full/obj16/home.png"));
        this.fHomeItem.setToolTipText(Messages.ConnectionPointComposite_TTP_Home);
        this.fHomeItem.addSelectionListener((SelectionListener)this);
        return main;
    }

    private Composite createPathComposite(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        main.setLayout((Layout)layout);
        this.fPathLink = new Link(main, 0);
        this.fPathLink.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final Font font = new Font((Device)this.fPathLink.getDisplay(), SWTUtils.boldFont((Font)this.fPathLink.getFont()));
        this.fPathLink.setFont(font);
        this.fPathLink.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                font.dispose();
            }
        });
        this.fPathLink.addSelectionListener((SelectionListener)this);
        ToolBar toolbar = new ToolBar(main, 0x800000);
        this.fRefreshItem = new ToolItem(toolbar, 8);
        this.fRefreshItem.setImage(SyncingUIPlugin.getImage("icons/full/obj16/refresh.gif"));
        this.fRefreshItem.setToolTipText(Messages.ConnectionPointComposite_TTP_Refresh);
        this.fRefreshItem.addSelectionListener((SelectionListener)this);
        return main;
    }

    private TreeViewer createTreeViewer(Composite parent) {
        this.fTreeViewer = new TreeViewer(parent, 67586);
        Tree tree = this.fTreeViewer.getTree();
        tree.setHeaderVisible(true);
        TreeColumn column = new TreeColumn(tree, 16384);
        column.setWidth(300);
        column.setText(COLUMN_NAMES[0]);
        column = new TreeColumn(tree, 16384);
        column.setWidth(50);
        column.setText(COLUMN_NAMES[1]);
        column = new TreeColumn(tree, 16384);
        column.setWidth(150);
        column.setText(COLUMN_NAMES[2]);
        this.fTreeViewer.setContentProvider((IContentProvider)new FileTreeContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new ConnectionPointLabelProvider());
        this.fTreeViewer.setComparator((ViewerComparator)new FileTreeNameSorter());
        this.fTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fTreeViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.fTreeViewer.addDragSupport(17, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)this);
        this.fTreeViewer.addDropSupport(17, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)this);
        tree.setMenu(this.createMenu((Control)tree));
        this.updateMenuStates();
        return this.fTreeViewer;
    }

    private Menu createMenu(Control parent) {
        Menu menu = new Menu(parent);
        this.fOpenItem = new MenuItem(menu, 8);
        this.fOpenItem.setText(CoreStrings.OPEN);
        this.fOpenItem.setAccelerator(0x100000C);
        this.fOpenItem.addSelectionListener((SelectionListener)this);
        this.fTransferItem = new MenuItem(menu, 8);
        this.fTransferItem.setText(Messages.ConnectionPointComposite_LBL_Transfer);
        this.fTransferItem.addSelectionListener((SelectionListener)this);
        new MenuItem(menu, 2);
        this.fDeleteItem = new MenuItem(menu, 8);
        this.fDeleteItem.setText(CoreStrings.DELETE);
        this.fDeleteItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ETOOL_DELETE"));
        this.fDeleteItem.setAccelerator(127);
        this.fDeleteItem.addSelectionListener((SelectionListener)this);
        this.fRenameItem = new MenuItem(menu, 8);
        this.fRenameItem.setText(CoreStrings.RENAME);
        this.fRenameItem.setAccelerator(0x100000B);
        this.fRenameItem.addSelectionListener((SelectionListener)this);
        new MenuItem(menu, 2);
        this.fRefreshMenuItem = new MenuItem(menu, 8);
        this.fRefreshMenuItem.setText(CoreStrings.REFRESH);
        this.fRefreshMenuItem.setImage(SyncingUIPlugin.getImage("/icons/full/obj16/refresh.gif"));
        this.fRefreshMenuItem.setAccelerator(0x100000E);
        this.fRefreshMenuItem.addSelectionListener((SelectionListener)this);
        new MenuItem(menu, 2);
        this.fPropertiesItem = new MenuItem(menu, 8);
        this.fPropertiesItem.setText(CoreStrings.PROPERTIES);
        this.fPropertiesItem.setAccelerator(65549);
        this.fPropertiesItem.addSelectionListener((SelectionListener)this);
        return menu;
    }

    private void gotoHome() {
        this.updateContent((IAdaptable)this.fConnectionPoint);
    }

    private void open(ISelection selection) {
        Object object = ((IStructuredSelection)selection).getFirstElement();
        if (object instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)object;
            if (Utils.isDirectory((IAdaptable)((IAdaptable)object))) {
                this.updateContent(adaptable);
            } else {
                OpenFileAction action = new OpenFileAction();
                action.updateSelection((IStructuredSelection)selection);
                action.run();
            }
        }
    }

    private void delete(ISelection selection) {
        final FileSystemDeleteAction action = new FileSystemDeleteAction(this.getControl().getShell(), this.fTreeViewer.getTree());
        action.updateSelection((IStructuredSelection)selection);
        action.addJobListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                UIUtils.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ConnectionPointComposite.this.refresh();
                    }
                });
                action.removeJobListener((IJobChangeListener)this);
            }
        });
        action.run();
    }

    private void rename() {
        FileSystemRenameAction action = new FileSystemRenameAction(this.getControl().getShell(), this.fTreeViewer.getTree());
        action.run();
        this.refresh();
    }

    private void refresh(ISelection selection) {
        if (selection.isEmpty()) {
            this.refresh();
        } else {
            Object[] elements;
            Object[] objectArray = elements = ((IStructuredSelection)selection).toArray();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                IResource resource = null;
                if (element instanceof IAdaptable) {
                    resource = (IResource)((IAdaptable)element).getAdapter(IResource.class);
                }
                if (resource != null) {
                    try {
                        resource.refreshLocal(2, null);
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                this.fTreeViewer.refresh(element);
                ++n2;
            }
        }
    }

    private void openPropertyPage(ISelection selection) {
        IAdaptable element = (IAdaptable)((IStructuredSelection)selection).getFirstElement();
        PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)this.getControl().getShell(), (IAdaptable)element, null, null, null);
        dialog.open();
    }

    private void setComboData(IAdaptable data) {
        this.fEndPointData.clear();
        if (data instanceof IContainer) {
            IContainer container = (IContainer)data;
            IContainer root = (IContainer)this.fConnectionPoint.getAdapter(IResource.class);
            String path = ConnectionPointComposite.getRelativePath(root, container);
            if (path != null) {
                String[] segments = new Path(path).segments();
                IContainer segmentPath = root;
                String[] stringArray = segments;
                int n = segments.length;
                int n2 = 0;
                while (n2 < n) {
                    String segment = stringArray[n2];
                    segmentPath = (IContainer)segmentPath.findMember(segment);
                    this.fEndPointData.add((IAdaptable)segmentPath);
                    ++n2;
                }
            }
        } else {
            IFileStore fileStore = Utils.getFileStore((Object)data);
            if (fileStore != null) {
                IFileStore homeFileStore = Utils.getFileStore((Object)this.fConnectionPoint);
                while (fileStore.getParent() != null && !fileStore.equals(homeFileStore)) {
                    this.fEndPointData.add(0, (IAdaptable)fileStore);
                    fileStore = fileStore.getParent();
                }
            }
        }
        this.fEndPointData.add(0, (IAdaptable)this.fConnectionPoint);
    }

    private void setPath(String path) {
        String displayedPath;
        String separator;
        StringBuilder linkPath = new StringBuilder();
        if ((path = path.replace('\\', '/')).startsWith(separator = "/")) {
            path = path.substring(1);
        }
        if ((displayedPath = FileUtil.compressLeadingPath((String)path, (int)60)).equals(path)) {
            String[] folders = path.split(separator);
            int i = 0;
            while (i < folders.length - 1) {
                linkPath.append(MessageFormat.format("<a href=\"{0}\">{1}</a>", i, folders[i]));
                linkPath.append(separator);
                ++i;
            }
            if (folders.length > 0) {
                linkPath.append(folders[i]);
            }
        } else {
            linkPath.append("...").append(separator);
            String endPath = displayedPath.substring(4);
            String[] endFolders = endPath.split(separator);
            int startIndex = path.split(separator).length - endFolders.length;
            int i = 0;
            while (i < endFolders.length - 1) {
                linkPath.append(MessageFormat.format("<a href=\"{0}\">{1}</a>", startIndex + i, endFolders[i]));
                linkPath.append(separator);
                ++i;
            }
            if (endFolders.length > 0) {
                linkPath.append(endFolders[i]);
            }
        }
        this.fPathLink.setText(String.valueOf(Messages.ConnectionPointComposite_LBL_Path) + linkPath.toString());
    }

    private void updateContent(IAdaptable rootElement) {
        this.setComboData(rootElement);
        if (rootElement instanceof IContainer) {
            this.setPath(ConnectionPointComposite.getRelativePath((IContainer)this.fConnectionPoint.getAdapter(IResource.class), (IContainer)rootElement));
        } else {
            IFileStore fileStore = Utils.getFileStore((Object)rootElement);
            if (fileStore != null) {
                String homePath;
                int index;
                String path = fileStore.toString();
                IFileStore homeFileStore = Utils.getFileStore((Object)this.fConnectionPoint);
                if (homeFileStore != null && (index = path.indexOf(homePath = homeFileStore.toString())) > -1) {
                    path = path.substring(index + homePath.length());
                }
                this.setPath(path);
            }
        }
        this.fTreeViewer.setInput((Object)rootElement);
    }

    private void updateMenuStates() {
        ISelection selection = this.fTreeViewer.getSelection();
        boolean hasSelection = !selection.isEmpty() && selection instanceof IStructuredSelection;
        boolean singleSelection = hasSelection && ((IStructuredSelection)selection).size() == 1;
        this.fOpenItem.setEnabled(hasSelection);
        this.fTransferItem.setEnabled(hasSelection);
        this.fDeleteItem.setEnabled(hasSelection);
        this.fRenameItem.setEnabled(hasSelection && singleSelection);
        this.fPropertiesItem.setEnabled(hasSelection && singleSelection);
    }

    private static IFileStore getFolderStore(IAdaptable destination) {
        IFileStore store = Utils.getFileStore((Object)destination);
        IFileInfo info = Utils.getFileInfo((IAdaptable)destination, (int)2048);
        if (store != null && info != null && !info.isDirectory()) {
            store = store.getParent();
        }
        return store;
    }

    private static String getRelativePath(IContainer root, IContainer element) {
        String rootPath = root.getFullPath().toString();
        String elementPath = element.getFullPath().toString();
        int index = elementPath.indexOf(rootPath);
        if (index == -1) {
            return null;
        }
        return elementPath.substring(index + rootPath.length());
    }

    public static interface Client {
        public void transfer(ConnectionPointComposite var1);
    }
}

